#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z (1.f)
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,0.f,1.f/FOND_Z,{1.f,1.f, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   128,255,128,   0,255.f,1.f/FOND_Z,{255.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   255,128,128,   0,255.f,1.f/FOND_Z,{255.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   128,128,255,   0,0.f,1.f/FOND_Z,{1.f,255.f/FOND_Z,1.f/FOND_Z}};

static BYTE Circle[64*64];
static DWORD SpeedX[] = {1,2,8,3,4,2,1,2,4,3,4,2,8,2,4,3,7,7};
static DWORD SpeedY[] = {1,3,3,4,1,3,8,3,3,4,7,3,1,3,3,4,1,3};
static DWORD Decal[] = {0,0,0,0,0,0,1000,2000,3000,4000,5000,6000,
	1500,2500,3500,4500,5500,6500};

void LInit_Lights()
{
	int Cpt1, Cpt2;
	DWORD Tmp;

	for(Cpt1=0;Cpt1<64;Cpt1++)
	{
		for(Cpt2=0;Cpt2<64;Cpt2++)
		{
			Tmp = (DWORD)sqrt(((Cpt1-32)*(Cpt1-32)+(Cpt2-32)*(Cpt2-32)));
			if (Tmp>=32)
			{
				Circle[Cpt1*64+Cpt2] = 0;
			}
			else
			{
				Circle[Cpt1*64+Cpt2] = (BYTE)(255 - Tmp*8);
			}
		}
	}

	PrepareTextureFromArray(g_PicFabfou, 256, 256, &g_TextureFabfou);
}

void QInit_Lights()
{
	grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grCullMode(GR_CULL_DISABLE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	DownloadTexture(&g_TextureFabfou);
	g_TextureBuff.info.format = GR_TEXFMT_ALPHA_8;

}

void Effect_Lights()
{
	int Cpt1, Cpt2, Cpt3;
	DWORD x,y;
	BYTE *pTmp;
	DWORD Value;

	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	SelectTexture(g_TextureFabfou);
	grAlphaTestFunction(GR_CMP_ALWAYS);
	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);

	//

	memset(g_FrameBuf3d, 0, 65536);
	for(Cpt1=0;Cpt1<sizeof(SpeedX)/sizeof(DWORD);Cpt1++)
	{
		x = 88 + 42*CosTable[(SpeedX[Cpt1]*g_demostate.TickInEffect+Decal[Cpt1])&8191];
		y = 88 + 42*SinTable[(SpeedY[Cpt1]*g_demostate.TickInEffect+Decal[Cpt1])&8191];

		for(Cpt2=0;Cpt2<64;Cpt2++)
		{
			for(Cpt3=0;Cpt3<64;Cpt3++)
			{
				pTmp = (BYTE*)g_FrameBuf3d + (Cpt2+y)*256+Cpt3+x;
				Value = *pTmp + Circle[Cpt2*64+Cpt3];
				if (Value>255)
					*pTmp = 255;
				else
					*pTmp = Value;
			}
		}
	}

	grAlphaTestFunction(GR_CMP_GREATER);
	grAlphaTestReferenceValue(128);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE,
							GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grTexDownloadMipMap(g_TextureBuff.tmu, g_TextureBuff.start,
						g_TextureBuff.evenOdd, &g_TextureBuff.info);
	SelectTexture(g_TextureBuff);

	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);
}

void ByeBye_Lights()
{
	FreeTexture(&g_TextureFabfou);
	grAlphaTestFunction(GR_CMP_ALWAYS);
}